﻿uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  theFileDriverInfo: TFileTypeInformation;

begin
  Result := -1; // Exclude
  if assigned(anEntry) then
  begin

    if RegexMatch(anEntry.EntryName, 'pagefile\.sys|memory\.dat|swapfile', false) then
      Result := 1;

    if Result = -1 then
    begin
      theFileDriverInfo := anEntry.DeterminedFileDriverInfo;
      if (theFileDriverInfo.ShortDisplayName <> null) and (trim(theFileDriverInfo.ShortDisplayName) <> '') then
      begin
        if RegexMatch(theFileDriverInfo.ShortDisplayName, 'Event Log|NTFS Table|Registry|USN Jrnl|Win Mem', false) then
          Result := 1;
      end;
    end;

  end;
end;

begin

end.
